<?php

namespace Plenty\Modules\Order\Models;

use Illuminate\Database\Eloquent\Model;

class OrderPositionOption extends Model 
{

    protected $table = 'plenty_order_position_option';
    public $timestamps = true;
    protected $guarded = array('id');
    protected $fillable = array('orderPositionId', 'typeId', 'subTypeId', 'value');
    protected $visible = array('id', 'orderPositionId', 'typeId', 'subTypeId', 'value', 'updatedAt', 'createdAt');

    public function orderPosition()
    {
        return $this->belongsTo('OrderPosition', 'orderPositionId');
    }

    public function type()
    {
        return $this->hasOne('OrderOptionType', 'id', 'typeId');
    }

    public function subType()
    {
        return $this->hasOne('OrderOptionSubType', 'id', 'subTypeId');
    }

}